# @public

# @doc entity/apply
# @input Amount of damage, score, @s, smithed.damage
#
# This function applies the specified amount of damage in half-hearts to the executing entity.
# ```mcfunction
# scoreboard players set @s[predicate=!1_splatus:not_creative_spec] smithed.damage 3    # Does 1.5 damage (3 half-hearts)
# function #smithed.damage:entity/apply         # Apply the damage
# ```
#
# To apply damage that respects armor, use their specific commands:  
# * [`function #smithed.damage:entity/apply/armor`](apply/armor.md): Respects armor, protection, and resistance  
# * [`function #smithed.damage:entity/apply/explosion`](apply/explosion.md): Respects the same as `armor`, but blast protection as well  
# * [`function #smithed.damage:entity/apply/projectile`](apply/projectile.md): Respects the same as `armor`, but projectile protection as well  

execute if entity @s[type=player] run function smithed.damage:v0.1.0/entity/health/calculate_modifier
execute if entity @s[type=!player] run function smithed.damage:v0.1.0/entity/health/get_entity_health

execute if score @s smithed.damage >= $maximumHealth smithed.damage run function smithed.damage:v0.1.0/entity/on_death
execute if score @s smithed.damage < $maximumHealth smithed.damage run function smithed.damage:v0.1.0/entity/health/update
scoreboard players reset @s smithed.damage
